<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1\Service;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
class UsAppToPersonContext extends InstanceContext {
    /**
     * Initialize the UsAppToPersonContext
     *
     * @param Version $version Version that contains the resource
     * @param string $messagingServiceSid The SID of the Messaging Service to fetch
     *                                    the resource from
     * @param string $sid The SID that identifies the US A2P Compliance resource to
     *                    fetch
     */
    public function __construct(Version $version, $messagingServiceSid, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['messagingServiceSid' => $messagingServiceSid, 'sid' => $sid, ];

        $this->uri = '/Services/' . \rawurlencode($messagingServiceSid) . '/Compliance/Usa2p/' . \rawurlencode($sid) . '';
    }

    /**
     * Delete the UsAppToPersonInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->version->delete('DELETE', $this->uri);
    }

    /**
     * Fetch the UsAppToPersonInstance
     *
     * @return UsAppToPersonInstance Fetched UsAppToPersonInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): UsAppToPersonInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new UsAppToPersonInstance(
            $this->version,
            $payload,
            $this->solution['messagingServiceSid'],
            $this->solution['sid']
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Messaging.V1.UsAppToPersonContext ' . \implode(' ', $context) . ']';
    }
}