function initGlobalSearch() {
    const components = [
        {
            icon: 'command',
            path: 'index2.html',
            title: 'CRM Dashboard',
            parent: 'Dashboard'
        },
        {
            icon: 'command',
            path: 'index3.html',
            title: 'Hospital',
            parent: 'Dashboard'
        },
        {
            icon: 'calendar',
            path: 'calendar.html',
            title: 'Calendar'
        },
        {
            icon: 'mail',
            path: 'email-inbox.html',
            title: 'Email Inbox',
            parent: 'Email'
        },
        {
            icon: 'mail',
            path: 'email-compose.html',
            title: 'Email Compose',
            parent: 'Email'
        },
        {
            icon: 'box',
            path: 'alerts.html',
            title: 'Alerts',
            parent: 'UI Components'
        },
        {
            icon: 'box',
            path: 'avatars.html',
            title: 'Avatars',
            parent: 'UI Components'
        },
        {
            icon: 'box',
            path: 'badges.html',
            title: 'Badges & Notes',
            parent: 'UI Components'
        },
        {
            icon: 'box',
            path: 'buttons.html',
            title: 'Buttons',
            parent: 'UI Components'
        },
        {
            icon: 'box',
            path: 'cards.html',
            title: 'Cards',
            parent: 'UI Components'
        },
        {
            icon: 'box',
            path: 'carousel.html',
            title: 'Carousel',
            parent: 'UI Components'
        },
        {
            icon: 'box',
            path: 'modals.html',
            title: 'Modals',
            parent: 'UI Components'
        },
        {
            icon: 'box',
            path: 'tabs.html',
            title: 'Tabs',
            parent: 'UI Components'
        },
        {
            icon: 'box',
            path: 'toasters.html',
            title: 'Toasters',
            parent: 'UI Components'
        },
        {
            icon: 'box',
            path: 'widgets.html',
            title: 'Widgets',
            parent: 'UI Components'
        },
        {
            icon: 'file-text',
            path: 'form-elements.html',
            title: 'Form Elements',
            parent: 'Forms'
        },
        {
            icon: 'file-text',
            path: 'form-validation.html',
            title: 'Form Validation',
            parent: 'Forms'
        },
        {
            icon: 'file-text',
            path: 'form-datetime-picker.html',
            title: 'Date & Time picker',
            parent: 'Forms'
        },
        {
            icon: 'file-text',
            path: 'checkbox-and-radios.html',
            title: 'Checkbox & Radios',
            parent: 'Forms'
        },
        {
            icon: 'file-text',
            path: 'form-editors.html',
            title: 'Text editors',
            parent: 'Forms'
        },
        {
            icon: 'file-text',
            path: 'form-uploads.html',
            title: 'File uploads',
            parent: 'Forms'
        },
        {
            icon: 'file-text',
            path: 'form-wizard.html',
            title: 'Form wizard',
            parent: 'Forms'
        },
        {
            icon: 'file-text',
            path: 'form-layouts.html',
            title: 'Form layouts',
            parent: 'Forms'
        },
        {
            icon: 'anchor',
            path: 'icon-feather.html',
            title: 'Feather Icon',
            parent: 'Icons'
        },
        {
            icon: 'anchor',
            path: 'icon-fontawesome.html',
            title: 'Font Awesome 5',
            parent: 'Icons'
        },
        {
            icon: 'pie-chart',
            path: 'chart-js.html',
            title: 'ChartJS',
            parent: 'Charts'
        },
        {
            icon: 'pie-chart',
            path: 'chartist-js.html',
            title: 'Chartist Chart',
            parent: 'Charts'
        },
        {
            icon: 'database',
            path: 'basic-table.html',
            title: 'Basic Table',
            parent: 'Tables'
        },
        {
            icon: 'database',
            path: 'datatable.html',
            title: 'Datatable',
            parent: 'Tables'
        },
        {
            icon: 'database',
            path: 'datatable-export.html',
            title: 'Datatable Export',
            parent: 'Tables'
        },
        {
            icon: 'key',
            path: 'login.html',
            title: 'Login',
            parent: 'Auth Pages'
        },
        {
            icon: 'key',
            path: 'register.html',
            title: 'Register',
            parent: 'Auth Pages'
        },
        {
            icon: 'key',
            path: 'forget-password.html',
            title: 'Forget Password',
            parent: 'Auth Pages'
        },
        {
            icon: 'key',
            path: 'reset-password.html',
            title: 'Reset Password',
            parent: 'Auth Pages'
        },
        {
            icon: 'book',
            path: 'profile.html',
            title: 'Profile Page',
            parent: 'Extra Pages'
        },
        {
            icon: 'book',
            path: 'error-400.html',
            title: 'Error 400',
            parent: 'Extra Pages'
        },
        {
            icon: 'book',
            path: 'error-401.html',
            title: 'Error 401',
            parent: 'Extra Pages'
        },
        {
            icon: 'book',
            path: 'error-403.html',
            title: 'Error 403',
            parent: 'Extra Pages'
        },
        {
            icon: 'book',
            path: 'error-404.html',
            title: 'Error 404',
            parent: 'Extra Pages'
        },
        {
            icon: 'book',
            path: 'error-500.html',
            title: 'Error 500',
            parent: 'Extra Pages'
        },
        {
            icon: 'book',
            path: 'blank.html',
            title: 'Blank Page',
            parent: 'Extra Pages'
        }
    ]

    components.forEach(item => {
        if (item.path && item.title) {
            let component = `<a class="dropdown-item d-flex align-items-center justify-content-between" href="${item.path}">
                            <div class="d-flex align-items-center">
                                ${item.icon ? `<i data-feather="${item.icon}" class="size-18 mr-2"></i> ` : ''}
                                <span class="title">${item.title}</span>
                            </div>
                            ${item.parent ? `<small class="parent-title text-muted font-italic"> ${item.parent} </small>` : ''}
                        </a>`;
            $(`#global-search .dropdown-menu`).append(component)
        }
    })

    document.querySelector('#global-search-input')
        .addEventListener('keyup', (e) => {
            let value = e.target.value.toLowerCase();
            document.querySelectorAll('#global-search .dropdown-menu .dropdown-item')
                .forEach((item, index) => {

                    let titleEl = item.querySelector('.title'),
                        parentTitleEL = item.querySelector('.parent-title'),
                        title = titleEl ? titleEl.textContent.toLowerCase() : '',
                        parentTitle = parentTitleEL ? parentTitleEL.textContent.toLowerCase() : '';

                    if (title.includes(value) || parentTitle.includes(value) || value === '') {
                        item.classList.remove('d-none');
                        item.classList.add('d-flex')
                    } else {
                        item.classList.remove('d-flex');
                        item.classList.add('d-none')
                    }
                })
        })
}
