function renderCharts() {
    weeklyAppointmentChart();
    weeklySurgeryChart();
    patientsOverview();
    activityChart();
}

const isChartElement = (element) => {
    return element ? element.tagName.toLowerCase() === 'canvas' : false
}

// Weekly Appointment Chart
function weeklyAppointmentChart() {
    let element = document.getElementById('weeklyAppointmentChart');

    if (isChartElement(element)) {
        let weeklyAppointmentChart = element.getContext('2d');
        let chart = new Chart(weeklyAppointmentChart, {
            type: 'line',
            data: {
                labels: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
                datasets: [{
                    borderColor: '#4466F2',
                    pointBackgroundColor: '#4466F2',
                    backgroundColor: 'rgba(68, 102, 242, 0.2)',
                    data: [15, 25, 20, 26, 22, 40, 35]
                },]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            display: false,
                            drawTicks: false
                        },
                        ticks: {
                            display: false,
                            beginAtZero: true
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            display: false,
                            drawTicks: false
                        },
                        ticks: {
                            display: false,
                            suggestedMin: 0,
                            suggestedMax: 50,
                            beginAtZero: true
                        }
                    }]
                },
            }
        });
    }
}

// Weekly Surgery Chart
function weeklySurgeryChart() {
    let element = document.getElementById('weeklySurgeryChart');

    if (isChartElement(element)) {
        let weeklySurgeryChart = element.getContext('2d');
        let chart = new Chart(weeklySurgeryChart, {
            type: 'line',
            data: {
                labels: ['Cardiac', 'Endocrine', 'Gynecological', 'Neurosurgery'],
                datasets: [{
                    borderColor: '#46c35f',
                    pointBackgroundColor: '#46c35f',
                    backgroundColor: 'rgba(70, 195, 95, 0.2)',
                    data: [20, 15, 35, 25]
                },]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            display: false,
                            drawTicks: false
                        },
                        ticks: {
                            display: false,
                            beginAtZero: true
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            display: false,
                            drawTicks: false
                        },
                        ticks: {
                            display: false,
                            suggestedMin: 0,
                            suggestedMax: 50,
                            beginAtZero: true
                        }
                    }]
                },
            }
        });
    }
}

// Patient Overview Chart
function patientsOverview() {
    let element = document.getElementById('patientsOverview')
    if (isChartElement(element)) {
        let patientsOverview = element.getContext('2d');
        let chart = new Chart(patientsOverview, {
            type: 'doughnut',
            data: {
                datasets: [{
                    borderWidth: 0,
                    data: [
                        200,
                        650,
                        350
                    ],
                    backgroundColor: [
                        'rgb(252, 44, 16)',
                        'rgb(70, 195, 95)',
                        'rgb(252, 101, 16)'
                    ]
                }],
                labels: [
                    'Male',
                    'Female',
                    'Other'
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false,
                },
                animation: {
                    animateScale: true,
                    animateRotate: true
                }
            }
        });
    }
}

// Activity Chart
function activityChart() {
    let element = document.getElementById('activityChart')
    if (isChartElement(element)) {
        let activityChart = element.getContext('2d');
        let chart = new Chart(activityChart, {
            type: 'bar',
            data: {
                labels: [
                    'Sun',
                    'Mon',
                    'Tue',
                    'Wed',
                    'Thu',
                    'Fri',
                    'Sat'
                ],
                datasets: [
                    {
                        borderWidth: 1,
                        barThickness: 15,
                        barPercentage: 0.5,
                        backgroundColor: '#4466F2',
                        borderColor: '#4466F2',
                        data: [80, 75, 60, 65, 100, 30, 90]
                    },
                    {
                        borderWidth: 1,
                        barThickness: 15,
                        barPercentage: 0.5,
                        backgroundColor: '#F56869',
                        borderColor: '#F56869',
                        data: [70, 85, 70, 40, 90, 50, 65]
                    }
                ]
            },

            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false,
                },
                elements: {
                    rectangle: {
                        borderWidth: 2,
                    }
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: xAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 12,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 50
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: yAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 14,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 100
                        }
                    }]
                }
            }
        });
    }
}