document.addEventListener('DOMContentLoaded', () => {
    // Fake events with datetime
    const addDateTime = (days = 0, hours = 0, minutes = 0, seconds = 0) => {
        return new Date(moment(new Date(), "DD-MM-YYYY")
            .add(days, 'days')
            .add(hours, 'hours')
            .add(minutes, 'minutes')
            .add(seconds, 'seconds')
            .toString());
    }
    let fakeEvents = [
        {
            title: 'All Day Event',
            start: addDateTime(),
            classNames: 'bg-success',
        },
        {
            title: 'Long Event',
            start: addDateTime(-2),
            classNames: 'bg-warning',
        },
        {
            title: 'Repeating Event',
            start: addDateTime(3),
            classNames: 'bg-info',
        },
        {
            title: 'Repeating Event 2',
            start: addDateTime(4),
            classNames: 'bg-primary',
        },
        {
            title: 'Conference',
            start: addDateTime(2),
            end: addDateTime(2, 3, 30),
            classNames: 'bg-secondary',
        },
        {
            title: 'Meeting',
            start: addDateTime(5),
            end: addDateTime(5, 3, 30),
            classNames: 'bg-success',
        },
        {
            title: 'Lunch',
            start: addDateTime(10),
            classNames: 'bg-dark',
        },
        {
            id: 8,
            title: 'Meeting',
            start: addDateTime(-1),
        },
        {
            title: 'Birthday Party',
            start: addDateTime(13),
            classNames: 'bg-success',
        },
        {
            title: 'Anniversary',
            start: addDateTime(1),
            end: addDateTime(1, 2),
            classNames: 'bg-danger',
        }
    ]

    // Calendar Initialize
    let calendarOptions = {
        initialView: 'dayGridMonth',
        initialDate: new Date(),
        editable: true,
        selectable: true,
        headerToolbar: {
            left: 'title',
            center: 'prev today next',
            right: 'dayGridMonth,timeGridWeek,timeGridDay',
        },
        events: fakeEvents,

        // Call Backs
        select: (arg) => {
            handleEvent(arg)
        },
        eventClick: (arg) => {
            updateEvent(arg)
        }
    }

    // Calendar initial and render
    const calendarEl = document.getElementById('calendar');
    const calendar = new FullCalendar.Calendar(calendarEl, calendarOptions);
    calendar.render();

    // Variables
    let startTime, endTime, actionType, currentEvent;
    const addEditModal = $(`#event-add-edit-modal`),
        modalTitle = $(`#event-add-edit-modal .modal-title`),
        inputName = $(`#event-name`)[0],
        inputColor = $(`#event-color`)[0],
        saveBtn = $(`#event-save`),
        deleteBtn = $(`#delete-event`);
    deleteBtn.addClass('invisible');

    // Add event
    const handleEvent = ({start, end}) => {
        addEditModal.modal('show');
        saveBtn.html('Save');
        modalTitle.html('Add Event');
        startTime = start;
        endTime = end;
        actionType = 'add';
    }
    const addEvent = (start, end, title, classNames) => {
        calendar.addEvent({
            title,
            start,
            end,
            classNames
        })
    }

    // Update Event
    const updateEvent = ({event}) => {
        currentEvent = event
        inputName.value = event.title;
        inputColor.value = event.classNames[0] ? event.classNames[0] : '';
        actionType = 'edit';
        saveBtn.html('Update');
        modalTitle.html('Edit Event');
        deleteBtn.removeClass('invisible');
        addEditModal.modal('show');
    }

    // Delete Event
    deleteBtn.on('click', () => {
        currentEvent.remove();
        deleteBtn.addClass('invisible');
        addEditModal.modal('hide');
    })

    // After click save or update
    saveBtn.on('click', () => {
        let title = inputName.value,
            bgColor = inputColor.value;
        if (actionType === 'add')
            addEvent(startTime, endTime, title ? title : 'Untitled Event', [bgColor]);
        else {
            currentEvent.setProp('classNames', [bgColor]);
            currentEvent.setProp('title', title);
        }
        addEditModal.modal('hide');
    })

    // After cancel
    addEditModal.on('hidden.bs.modal', (e) => {
        inputName.value = '';
        inputColor.value = '';
        startTime = '';
        endTime = '';
        currentEvent = null;
        deleteBtn.addClass('invisible')
    });
});
