<?php

/*
 * ATTENTION
 * Before you executing this request, please keep in mind the following:
 * 1. There must be folder named "original" inside the public_html
 * 2. All files/folders will be removed except the "original" once you execute this
 * 3. All files/folders will be copied to public_html from original folder
 * 4. All files/folders will be re-structured to work with cPanel
 * */


//So now, the we've verified the request. Go ahead!

set_time_limit(300); //set execution time = 5 minutes. Since it could take time.


echo "- Start removing all existing files from cPanel root. Except the original folder \r\n";
remove_all_except_original_recursive();

echo "- Copy everything from the original folder to root \r\n";
copy_original_to_root();


function custom_copy($src, $dst)
{
    if (is_dir($src)) {
        $dir = opendir($src);

        // Make the destination directory if not exist
        if (!is_dir($dst)) {
            mkdir($dst, 0755, true);
        }

        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    copy($src . '/' . $file, $dst . '/' . $file);
                }
            }
        }

        closedir($dir);

    } else if ($src) {
        copy($src, $dst);  // Copy file
    }
}


function rmdir_recursive($dir)
{
    foreach (scandir($dir) as $file) {
        if ('.' === $file || '..' === $file) continue;
        if (is_dir("$dir/$file")) rmdir_recursive("$dir/$file");
        else unlink("$dir/$file");
    }
    rmdir($dir);
}


function move_documentation_from_public_to_root()
{
    $docs_path = "public" . DIRECTORY_SEPARATOR . "documentation";
    $source = get_absolute_path($docs_path);
    $dst = str_replace("public_html", "root_html", $source); // Backup public_html
    $dst = str_replace($docs_path, "", $dst);
    $dst_doc_path = "public_html" . DIRECTORY_SEPARATOR . "documentation";
    $dst = str_replace("root_html", $dst_doc_path, $dst); // Put back public_html

    if (is_dir($source)) {
        custom_copy($source, $dst);
        rmdir_recursive($source); // Remove directory
    }
}


function get_absolute_path($file_path = "", $show_original_folder = false)
{
    $root = dirname(__FILE__);

    if (!$show_original_folder) {
        $root = str_replace(DIRECTORY_SEPARATOR . get_original_folder_name(), "", $root);
    }

    if ($file_path) return $root . DIRECTORY_SEPARATOR . $file_path;
    else return $root;
}


function copy_original_to_root()
{
    $source = get_absolute_path("", true);

    $dst = str_replace(get_original_folder_name(), "", $source);

    if (is_dir($source)) {
        custom_copy($source, $dst);
    }
}


function get_original_folder_name()
{
    return "original";
}


function remove_all_except_original_recursive()
{
    $dir = get_absolute_path();

    foreach (scandir($dir) as $file) {
        if ('.' === $file || '..' === $file) continue;

        if (is_dir("$dir/$file")) {
            if ($file == get_original_folder_name()) {
                // Don't remove

            } else {
                rmdir_recursive("$dir/$file"); // Remove directory
            }
        } else {
            unlink("$dir/$file"); // Remove file
        }
    }
}
